<?php
/**
 * REST API Shortcode options.
 *
 * @package AjaxLoadMore
 */

if ( has_action( 'alm_rest_api_installed' ) ) {
	$restapi_baseurl = '/wp-json';
	if ( isset( $alm_options['_alm_rest_api_base_url'] ) ) {
		$restapi_baseurl = $alm_options['_alm_rest_api_base_url'];
	}

	$restapi_namespace = 'ajaxloadmore';
	if ( isset( $alm_options['_alm_rest_api_namespace'] ) ) {
		$restapi_namespace = $alm_options['_alm_rest_api_namespace'];
	}

	$restapi_endpoint = 'posts';
	if ( isset( $alm_options['_alm_rest_api_endpoint'] ) ) {
		$restapi_endpoint = $alm_options['_alm_rest_api_endpoint'];
	}
	?>
<div class="row input rest add-on" id="alm-rest">
	<h3 class="heading" tabindex="0"><?php esc_attr_e( 'REST API', 'ajax-load-more' ); ?></h3>
	<div class="expand-wrap">

		<section class="first">
			<div class="shortcode-builder--label">
				<p><?php esc_attr_e( 'Enable the WordPress REST API.', 'ajax-load-more' ); ?></p>
			</div>
			<div class="shortcode-builder--fields">
				<div class="inner">
					<ul>
						<li>
						<input class="alm_element" type="radio" name="rest" value="true" id="rest-true" >
						<label for="rest-true"><?php esc_attr_e( 'True', 'ajax-load-more' ); ?></label>
						</li>
						<li>
						<input class="alm_element" type="radio" name="rest" value="false" id="rest-false"  checked="checked">
						<label for="rest-false"><?php esc_attr_e( 'False', 'ajax-load-more' ); ?></label>
						</li>
					</ul>
				</div>
			</div>
		</section>

		<div class="restapi_options nested-component">
			<div class="nested-component--inner">
				<section>
					<div class="shortcode-builder--label">
						<h4><?php esc_attr_e( 'Base URL', 'ajax-load-more' ); ?>
						<a href="javascript:void(0)" class="fa fa-question-circle tooltip" title="<?php esc_attr_e( 'Set a default Base URL in the Ajax Load More settings panel', 'ajax-load-more' ); ?>."></a></h4>
						<p><?php esc_attr_e( 'Enter the base URL to your installation of the REST API.', 'ajax-load-more' ); ?></p>
					</div>
					<div class="shortcode-builder--fields">
						<div class="inner">
							<input type="text" id="rest-base" class="alm_element" name="rest-base" value="<?php echo $restapi_baseurl; ?>">
						</div>
					</div>
				</section>

				<section>
					<div class="shortcode-builder--label">
						<h4><?php esc_attr_e( 'Namespace', 'ajax-load-more' ); ?>
						<a href="javascript:void(0)" class="fa fa-question-circle tooltip" title="<?php esc_attr_e( 'Set a default Namespace in the Ajax Load More settings panel', 'ajax-load-more' ); ?>."></a></h4>
						<p><?php esc_attr_e( 'Enter the custom namespace for this Ajax Load More query.', 'ajax-load-more' ); ?></p>
					</div>
					<div class="shortcode-builder--fields">
						<div class="inner">
							<input type="text" id="rest-namespace" class="alm_element" name="rest-namespace" value="<?php echo $restapi_namespace; ?>">
						</div>
					</div>
				</section>

				<section>
					<div class="shortcode-builder--label">
						<h4><?php esc_attr_e( 'Endpoint', 'ajax-load-more' ); ?>
						<a href="javascript:void(0)" class="fa fa-question-circle tooltip" title="<?php esc_attr_e( 'Set a default Endpoint in the Ajax Load More settings panel', 'ajax-load-more' ); ?>."></a></h4>
						<p><?php esc_attr_e( 'Enter your custom endpoint for this Ajax Load More query.', 'ajax-load-more' ); ?></p>
					</div>
					<div class="shortcode-builder--fields">
						<div class="inner">
							<input type="text" id="rest-endpoint" class="alm_element" name="rest-endpoint" value="<?php echo $restapi_endpoint; ?>">
						</div>
					</div>
				</section>

				<section>
					<div class="shortcode-builder--label">
						<h4><?php esc_attr_e( 'Template ID', 'ajax-load-more' ); ?> <a href="javascript:void(0)" class="fa fa-question-circle tooltip" title="<?php esc_attr_e( 'Ajax Load More references this ID while looping and displaying your data. You must still select a repeater template for this instance of Ajax Load More', 'ajax-load-more' ); ?>">.</a></h4>
						<p><?php _e( 'Enter the ID of your javascript template.<br/><br/>e.g. <em>tmpl-alm-template</em> = <em>alm-template</em>', 'ajax-load-more' ); ?><br/>&raquo; <a href="https://gist.github.com/dcooney/c89f5859b73256b36de4a0c3320d9b07" target="_blank"><?php _e( 'View Example', 'ajax-load-more' ); ?></a></p>
					</div>
					<div class="shortcode-builder--fields">
						<div class="inner">
							<input type="text" id="rest-template-id" class="alm_element" name="rest-template-id" value="">
						</div>
					</div>
				</section>

				<section>
					<div class="shortcode-builder--label">
						<h4><?php esc_attr_e( 'Debug Mode', 'ajax-load-more' ); ?></h4>
						<p><?php esc_attr_e( 'Enable debugging (console.log) of REST API responses in the browser console. ', 'ajax-load-more' ); ?></p>
					</div>
					<div class="shortcode-builder--fields">
						<div class="inner">
							<ul>
								<li>
									<input class="alm_element" type="radio" name="rest-debug" value="true" id="rest-debug-true" >
									<label for="rest-debug-true"><?php esc_attr_e( 'True', 'ajax-load-more' ); ?></label>
								</li>
								<li>
									<input class="alm_element" type="radio" name="rest-debug" value="false" id="rest-debug-false"  checked="checked">
									<label for="rest-debug-false"><?php esc_attr_e( 'False', 'ajax-load-more' ); ?></label>
								</li>
							</ul>
						</div>
					</div>
				</section>
				<p class="warning-callout">
					<?php _e( 'Visit <a href="http://v2.wp-api.org/" target="_blank">http://v2.wp-api.org</a> for documentation on creating custom <a href="http://v2.wp-api.org/extending/adding/" target="_blank">Endpoints</a> for use with Ajax Load More.', 'ajax-load-more' ); ?>
				</p>
			</div>
		</div>
	</div>
</div>
<?php } ?>
