<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package gerald-simpson
 */

get_header();
?>

<!--INNER BANNER SECTION-->
<section class="inner-banner" style="background-image: url('/wp-content/uploads/2022/03/banner.jpg');">
    <div class="container">
        <div class="row">
            <div class= "col-md-12">
                <div class="banner-content">
                    <h1>Available Properties</h1>
                    <strong class="fade-back">Could Yours Be Listed Soon?</strong>
                </div>            
            </div>
        </div>
    </div>
</section>


<!--PROPERTY SECTION-->
<section class="property">
    <div class="container">
        <div class="row project-wrap">
            <div class="col-md-12">
                <?php 
 				echo do_shortcode('[searchandfilter post_type="properties" fields="rent,location,bedroom,bathroom,property-type"]'); ?>
                
            
            <?php
echo '<ul class="nav nav-tabs" role="tablist">';

$args = array(
    'taxonomy' => 'status',
    'hide_empty'=>0,
    'orderby' => 'name',
    'order' => 'ASC'
);
$categories = get_categories($args);
foreach($categories as $category) { 
// 	echo '<pre>';
// 	print_r($category->category_nicename);
    echo 
        '<li>
            <p class="click-button" data-href="'.$category->slug.'" role="tab" data-toggle="tab">    
                '.$category->name.'
            </p>
        </li>';
}
echo '</ul>';
echo '</div>';
echo '<div class="property-tab-content">';

foreach($categories as $category) { 
    echo '<div class=" row tab-pane" id="' . $category->slug.'">';
// 	echo $category->slug;

// 	if($category->category_nicename == $category->slug){
		
	
    $catslug = $category->slug;
    $the_query = new WP_Query(array(
        'post_type' => 'properties',
        'posts_per_page' => -1,
        'tax_query' => array(
                        array(
                            'taxonomy' => 'status',
                            'field'    => 'slug',
                            'terms'    => array( $catslug ),
                            'operator' => 'IN'
                        ),
                    ),
    )); 
// 	if(empty(have_posts())){
// 		echo "No products found";
// 	}
// 	print_r(have_posts());
    while ( have_posts() ) :
    the_post();
// 	echo $catslug;
	$get_terrm = get_the_terms( get_the_ID(), 'status' );
// 	print_r($get_terrm[0]->slug);
// 		print_r($get_terrm);
	if($get_terrm[0]->slug == $catslug){
		
	
    $featured_img = get_the_post_thumbnail_url(get_the_ID(), 'full');?>
       <div class="col-md-4">
                <div class="property-card">
                 <img src="<?php echo $featured_img;?>">
                 <div class="sale-tag">
                    <?php echo $catslug ?>
                 </div>
                    <div class="property-inner">
                        <div class="property-intro">
                            <ul>
                                <li><?php the_title();?></li>
                                <li><?php the_field('price');?></li>    
                            </ul>
                        </div>
                        <div class="property-content">
                            <?php the_content();?>
                        </div>
                       <!-- <?php the_excerpt();?> -->
						<?php
						if ($catslug == "sale") {						
						?>
                        <a href="<?php the_permalink();?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18.676" height="10.272" viewBox="0 0 18.676 10.272">
  <path id="arrow_7_" data-name="arrow (7)" d="M289.342,6519.27a.994.994,0,0,1,1.367,0l8,7.718a1.82,1.82,0,0,1,0,2.639l-8.054,7.775a1,1,0,0,1-1.358.008.91.91,0,0,1-.01-1.33l7.371-7.112a.911.911,0,0,0,0-1.321l-7.312-7.057a.91.91,0,0,1,0-1.32" transform="translate(6537.673 -289) rotate(90)" fill="#fff" fill-rule="evenodd"/>
</svg>
                        </a>
						<?php }
						?>
                    </div>
                </div>
            </div>

    <?php
	}
		endwhile; 
    echo '</div>';
} wp_reset_query();
// }
echo '</div>';
?>
        </div>
    </div>
</section>

<!--TESTIMONIAL SECTION-->
<?php get_template_part('template-parts/client','testimonial');?>

<?php
get_footer();
