<!DOCTYPE html>
<html>

<head>
    <title><?php wp_title(''); ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	
    <?php wp_head();?>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-8XD73Q6MS0"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-8XD73Q6MS0');
</script>
</head>

<body <?php body_class();?> data-aos-easing="ease" data-aos-duration="400" data-aos-delay="0">

<!-- HEADER SECTION -->
<header id="header">
    <div class="container">
        <div class="row header-mt">
            <div class="col-lg-3 col-md-5">
                <div class="site-logo">
                    <a href="<?php echo home_url(); ?>">
                        <img class="img-fluid" src="<?php the_field('header_logo','options');?>" alt="">
                    </a>
                </div>
            </div>
            <div class="col-lg-9 col-md-6">
                <div class="row top-head">
                    <div class="col-md-12">
                        <div class="contact-links">
                            <ul>
                                <li>
                                    <div class="phone_h">
                                        <a href="tel:<?php the_field('phone_no', 'options');?>">
                                            <?php the_field('phone_no', 'options');?>
                                        </a>   
                                    </div>                                        
                                </li>
                                <li>
                                    <div class="button_h">
                                        <a class="btn-h" href="<?php the_field('header_button_link', 'options');?>/contact">
                                            <?php the_field('header_button', 'options');?>
                                        </a>
                                    </div>  
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-12 px-0">
                        <div class="main-nav">
                            <nav id="nav-menu-container">
                                <?php
                                    wp_nav_menu(array(
                                    'menu' => 'Main Menu',
                                    'menu_class' => 'nav-menu',
                                    'container' => 'ul',
                                    'theme_location' => 'primary',
                                    'depth' => 2,
                                    ));
                                ?>
                           </nav><!-- #nav-menu-container --> 
                        </div>    
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>