<?php
/**
 * Template Name: Home
 * */
get_header();
?>

<!--MAIN BANNER SECTION-->
<?php if( have_rows('main_banner') ): ?>
        <?php while( have_rows('main_banner') ): the_row(); ?>
<section class="main-banner" style="background-image: url('<?php the_sub_field('background_image');?>');">
    <div class="container">
        <div class="row">
        	<div class= "col-lg-8 col-md-12">
        		<div class="banner-content">
                    <strong><?php the_sub_field('subheading');?></strong>
                    <h1><?php the_sub_field('heading');?></h1>
                    <ul>
                        <li>
                            <a class="btn-h" href="<?php the_sub_field('button_1_link');?>"><?php the_sub_field('button_1');?></a></li>
                        <li><a class="btn-h" href="<?php the_sub_field('button_2_link');?>"><?php the_sub_field('button_2');?></a></li>
                    </ul>
        	     
        		</div>       
        	</div>
            <div class= "col-lg-4 col-md-12">
                <img src="<?php the_sub_field('ceo_image_banner');?>">
            </div>
        </div>
    </div>
</section>
<?php endwhile; endif; ?>


<!--GALLERY SECTION-->

<section class="gallery">
    <div class="container">
         <div class="gallery-overlay"></div>
		<div class="row">
			<div class="col-lg-11 col-md-12 m-auto">
				<div class="row ">
            <?php if( have_rows('gallery_section') ): ?>
                <?php while( have_rows('gallery_section') ): the_row(); ?>
                <div class="col-lg-3 col-md-6 d-flex justify-content-center">
                    <div class="content">
						<div class="bg-overlay"></div>
                        <div class="content-overlay"></div>
                        <img class="content-image" src="<?php the_sub_field('image');?>">
                        <div class="con-h">
                            <h2><?php the_sub_field('heading');?></h2>
                        </div>
                        <div class="content-details fadeIn-down">
                            <h2><?php the_sub_field('heading');?></h2>
                            <?php the_sub_field('content');?>
                        </div>
                    </div>
                </div>
            <?php endwhile; endif; ?>
        </div>
			</div>
		</div>
        
        <div class="row">
            <div class="col-md-12 abt-home">
                <!--ABOUT SECTION-->
                    <?php get_template_part('template-parts/about','section');?>
            </div>
        </div>
    </div>

</section>


<!--APPRAISAL SECTION-->
<section class= "appraisal">
    <div class="container">
        <div class="row">
            <?php if( have_rows('appraisal_section') ): ?>
            <?php while( have_rows('appraisal_section') ): the_row(); ?>
            <div class= "col-lg-7 col-md-12">
                <div class="appraisal-img">
                    <img src="<?php the_sub_field('image');?>">                  
                </div>
            </div>
            <div class= "col-lg-5 col-md-12">
                <div class= "appraisal-content">
                    <h2><?php the_sub_field('heading');?></h2>
                    <?php the_sub_field('content');?>
                    <div class="button_h">
                        <a class="btn-h" href="<?php the_sub_field('button_link');?>">
                            <?php the_sub_field('button');?>
                        </a>
                    </div>    
                </div>
            </div>
            <?php endwhile; endif; ?>
        </div>
    </div>
</section>

<section class= "properties-home">
    <div class="container">
        <div class="row">
            <div class= "col-md-12">
                <h2>Properties For Sale</h2>
            </div>
        </div>
		<?php
				
                    $args = array(
                    'post_type' => 'properties',
                        'order' => 'ASC',
                     'posts_per_page' => -1,
						'tax_query' => array(
                        array(
                            'taxonomy' => 'status',
                            'field'    => 'slug',
                            'terms'    => 'sale',
                            
                        ),
                    ),
                    );?>
                    
                <?php
                $query = new WP_Query($args);?>
  <div class="contentt">
  <div class="slider">
	  <?php               
                while($query->have_posts()){
                    $query->the_post();
                    $featured_img = get_the_post_thumbnail_url(get_the_ID(), 'full');
                ?> 
    <div> 
      <div class="imagee">
        <div class="property-card">   
                 <img src="<?php echo $featured_img;?>">
                    <div class="property-inner">
                        <div class="property-intro">
                            <ul>
                                <li><?php the_title();?></li>
                                <li><?php the_field('price');?></li>    
                            </ul>
                        </div>
                        <div class="property-content">
                            <?php the_content();?>
                        </div>
                        <!-- <?php the_excerpt();?> -->
                        <a href="<?php the_permalink();?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18.676" height="10.272" viewBox="0 0 18.676 10.272">
  <path id="arrow_7_" data-name="arrow (7)" d="M289.342,6519.27a.994.994,0,0,1,1.367,0l8,7.718a1.82,1.82,0,0,1,0,2.639l-8.054,7.775a1,1,0,0,1-1.358.008.91.91,0,0,1-.01-1.33l7.371-7.112a.911.911,0,0,0,0-1.321l-7.312-7.057a.91.91,0,0,1,0-1.32" transform="translate(6537.673 -289) rotate(90)" fill="#fff" fill-rule="evenodd"/>
</svg>
                        </a>
                    </div>
                    </div>
      </div>
		</div><!-- end image -->
		<?php } wp_reset_query(); ?> 
    
  </div> <!-- end slider -->
  <div class="progress" role="progressbar" aria-valuemin="0" aria-valuemax="100">
    <span class="slider__label sr-only">
  </div>
  </span>
</div>
	</div> 
</section>

<!--ANOTHER APPRAISAL SECTION-->
<section class= "appraisal other-appraisal">
    <div class="container">
        <div class="row">
            <?php if( have_rows('another_appraisal_section') ): ?>
                <?php while( have_rows('another_appraisal_section') ): the_row(); ?>
            <div class= "col-lg-5 col-md-12">
                <div class= "appraisal-content">
                    <h2><?php the_sub_field('heading');?></h2>
                    <?php the_sub_field('content');?>
                    <div class="button_h">
                        <a class="btn-h" href="<?php the_sub_field('button_link');?>">
                            <?php the_sub_field('button');?>
                        </a>
                    </div>    
                </div>
            </div>
            <div class= "col-lg-7 col-md-12">
                <div class="appraisal-img">
                    <img src="<?php the_sub_field('image');?>">                  
                </div>
            </div>
            <?php endwhile; endif; ?>
        </div>
    </div>
</section>



<!--BLOG PAGE SECTION-->
<section class="blog-single-post">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h2>Blogs</h2>
            </div>
            <?php
                    $args = array(
                    'post_type' => 'post',
                        'order' => 'DESC',
                     'posts_per_page' => 3,
                    
                    );
                $query = new WP_Query($args);
                while($query->have_posts()){
                    $query->the_post();
                    $featured_img = get_the_post_thumbnail_url(get_the_ID(), 'full');
                ?>

            <div class="col-lg-4 col-md-6 col-sm-12">
                <div class="blog-card">
                 <img src="<?php echo $featured_img;?>">  
                    <div class="blog-card-inner">
                        <div class="blog-intro">
                            <ul>
                                <li>By <?php echo get_the_author(); ?>:</li>
                                <li><?php echo get_the_date();?></li>    
                            </ul>
                        </div>
                        <h5><?php the_title();?></h5>
						<div class="blog-content">
                        	<?php the_content();?>
						</div>
                        <a href="<?php the_permalink();?>">Read More</a>
                    </div>
                </div>
            </div>
            <?php } wp_reset_query(); ?>
        </div>
    </div>
</section>

<script>
		jQuery(document).ready(function() {
  var $slider = jQuery('.slider');
  var $progressBar = jQuery('.progress');
  var $progressBarLabel = jQuery( '.slider__label' );
  
  $slider.on('beforeChange', function(event, slick, currentSlide, nextSlide) {   
    var calc = ( (nextSlide) / (slick.slideCount-1) ) * 100;
    
    $progressBar
      .css('background-size', calc + '% 100%')
      .attr('aria-valuenow', calc );
    
    $progressBarLabel.text( calc + '% completed' );
  });
  
  $slider.slick({
    slidesToShow: 3,
    slidesToScroll: 1,
    speed: 400,
	responsive: [
		 {
            breakpoint: 1500,
            settings: {
                slidesToShow: 3,
                slidesToScroll: 1,
            }
        },
        {
            breakpoint: 1200,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 1,
            }
        },
		{
            breakpoint: 991,
            settings: {
                slidesToShow: 1,
                slidesToScroll: 1,
            }
        },
		]
  });  
});</script>

<!--TESTIMONIAL SECTION-->
<?php get_template_part('template-parts/client','testimonial');?>

<?php
get_footer();
?>