<?php 
/**
   * Template Name: Blogs
   */
get_header();
?>

<!--INNER BANNER SECTION-->
<?php get_template_part('template-parts/inner','banner');?>

<!--BLOG PAGE SECTION-->
<section class="blogs-sec">
    <div class="container">
        <div class="row">
            <?php
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
				$args = array(
				  'posts_per_page' => 3,
				   'post_type' => 'post',
				  'paged' => $paged
				);
                $query = new WP_Query($args);
                while($query->have_posts()){
                    $query->the_post();
                    $featured_img = get_the_post_thumbnail_url(get_the_ID(), 'full');
                ?>

            <div class="col-lg-4 col-md-6 col-sm-12">
                <div class="blog-card">
                 <img src="<?php echo $featured_img;?>">  
                    <div class="blog-card-inner">
                        <div class="blog-intro">
                            <ul>
                                <li>By <?php echo get_the_author(); ?>:</li>
                                <li><?php echo get_the_date();?></li>    
                            </ul>
                        </div>
                        <h5><?php the_title();?></h5>
                        <div class="blog-content">
                            <?php the_content();?>
                        </div>
                        <!-- <?php the_excerpt();?> -->
                        <a href="<?php the_permalink();?>">Read More</a>
                    </div>
                </div>
            </div>
            <?php } 
			echo '<div class="pagination">';
			$big = 999999999; // need an unlikely integer
            echo paginate_links(
                array(
                    'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                    'format' => '?paged=%#%',
                    'current' => max(
                        1,
                        get_query_var('paged')
                    ),
                    'total' => $query->max_num_pages //$q is your custom query
                )
            );
			echo '</div>';
		
			wp_reset_query(); ?>
        </div>
    </div>
</section>

<!--TESTIMONIAL SECTION-->
<?php get_template_part('template-parts/client','testimonial');?>

<?php 
get_footer();
?>