<?php
  /**
   * Template Name: Sellers & Landlords
   */
get_header();  ?>

<!--INNER BANNER SECTION-->
<?php get_template_part('template-parts/inner','banner');
$get_group = get_field('bottom_section');

?>

<!--SELLER AND LANDLORD SECTION-->
<!--ANOTHER APPRAISAL SECTION-->
<section class= "appraisal seller-top">
    <div class="container">
        <div class="row">
            <?php if( have_rows('top_section') ): ?>
            <?php while( have_rows('top_section') ): the_row(); ?>
            <div class= "col-md-12 col-lg-6">
                <div class= "appraisal-content">
                    <h2><?php the_sub_field('heading');?></h2>
                    <?php the_sub_field('content');?>
                    <div class="button_h">
                        <a class="btn-h" href="<?php the_sub_field('button_link');?>">
                            <?php the_sub_field('button');?>
                        </a>
                    </div>    
                </div>
            </div>
            <div class= "col-md-12 col-lg-6">
                <div class="appraisal-img">
                    <img src="<?php the_sub_field('image');?>">                  
                </div>
            </div>
            <?php endwhile; endif; ?>
        </div>
    </div>
</section>

<!--ANOTHER APPRAISAL SECTION-->
<section class= "appraisal other-appraisal seller">
    <div class="container">
        <div class="row align">
            <?php if( have_rows('bottom_section') ): ?>
            <?php while( have_rows('bottom_section') ): the_row(); ?>
            <div class= "col-lg-7 col-md-12">
                <div class="appraisal-img">
                    <img src="<?php the_sub_field('image');?>">                  
                </div>
            </div>
            <div class= "col-lg-5 col-md-12">
                <div class= "appraisal-content">
                    <h2><?php the_sub_field('heading');?></h2>
                    <h3><?php the_sub_field('subheading');?></h3>
                    <?php the_sub_field('content');?> 
					<div class="button_h two-buttons">
						<div>
							<a class="btn-h" href="<?php the_sub_field('button_link');?>">
								<?php the_sub_field('button');?>
							</a>							
						</div>
						<div class="second-btn">
							<a class="btn-h" href="<?php echo $get_group['rental_quote'];?>">
								<?php echo $get_group['rental_quote_text'];?>
							</a>
						</div>
                    </div>  
                </div>
            </div>
            <?php endwhile; endif; ?>
        </div>
    </div>
</section>

<!--PROPERTY SECTION-->
<?php get_template_part('template-parts/feature','properties');?>

<!--TESTIMONIAL SECTION-->
<?php get_template_part('template-parts/client','testimonial');?>

<?php get_footer();?>