<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package gerald-simpson
 */

get_header();
?>
<!--INNER BANNER SECTION-->
<section class="inner-banner" style="background-image: url('/wp-content/uploads/2022/03/banner.jpg');">
    <div class="container">
        <div class="row">
            <div class= "col-md-12">
                <div class="banner-content">
                    <h1></h1>
                    <strong class="fade-back"></strong>
                </div>            
            </div>
        </div>
    </div>
</section>

<section id="primary" class="site-main search-page">
<div class="container">
    <div class= "row">
        <div class= "col-md-12">
<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<h1 class="page-title">
					<?php
					/* translators: %s: search query. */
					printf( esc_html__( 'Search Results for: %s', 'gerald-simpson' ), '<span>' . get_search_query() . '</span>' );
					?>
				</h1>
			</header><!-- .page-header -->

			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				get_template_part( 'template-parts/content', 'search' );

			endwhile;

			the_posts_navigation();

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>
			<?php get_sidebar();?>
        </div>
    </div>
</div>
</section>

<?php

get_footer();
