<?php  
/**
 * The template for displaying all single posts and attachments
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 * 
 * Template Name: Properties Post
 */
get_header();
?>

<!--PROPERTY SECTION-->
<section class="project-banner">
    <div class="container-fluid">
        <div class="row px-0">
            <div class="col-md-12 px-0">
               <!-- <div class="banner-slider">
                
                    <?php if( have_rows('property_images') ): ?>
                    <?php while( have_rows('property_images') ): the_row(); ?>
                        
                            <img src="<?php the_sub_field('image');?>">
                        
                    <?php endwhile; endif; ?>
            
                </div>   -->
				<div class="banner-slider">
					<?php if( have_rows('property_images') ): ?>
                    <?php while( have_rows('property_images') ): the_row(); ?>
                        
                          <a href="<?php the_sub_field('image');?>" data-lightbox="roadtrip"> <img data-lightbox="roadtrip" class="ImgThumbnail" src="<?php the_sub_field('image');?>"></a>
                        
                    <?php endwhile; endif; ?>

				</div>
            </div>
        </div>
     </div>
</section>

<!--DESCRIPTION SECTION-->
<?php if( have_rows('property_info') ): ?>
<?php while( have_rows('property_info') ): the_row(); ?>
<section class="pro-info">
    <div class="container">
        <div class="row">
            <?php
                    $args = array(
                    'post_type' => 'properties',
                        'order' => 'DESC',
                        'posts_per_page' => 1,
                    
                    );
                $query = new WP_Query($args);
                while($query->have_posts()){
                    $query->the_post();
                    $featured_img = get_the_post_thumbnail_url(get_the_ID(), 'full');
					$properties= the_post();
                    $beds = get_the_terms( $properties->ID, 'bedroom' );
					$baths = get_the_terms( $properties->ID, 'bathroom' );
                ?>
            <div class="col-md-12">
                <div class="property-top">
                    <strong><?php the_field('price');?></strong>
                    <ul>
                        <li>
                            <?php if( have_rows('property_size') ): ?>
                                <?php while( have_rows('property_size') ): the_row(); ?>
                            <div class="pro-size">
                                <p>
                                    <span><?php the_sub_field('heading');?> </span>
                                    <?php the_sub_field('content');?>
                                </p>
                            </div> 
                            <?php endwhile; endif; ?> 
                        </li>
                        <li>
                            <div class="bed">
                                <p>
                                    <span><?php the_sub_field('bedroom_heading');?></span>
                                    <?php foreach ( $beds as $bed ){
                                        echo $bed->name;
                                    }?> Rooms
                                </p>
                            </div>                                       
                        </li>
                        <li>
                            <?php if( have_rows('garrage') ): ?>
                                <?php while( have_rows('garrage') ): the_row(); ?>
                            <div class="garrage">
                                <p>
                                    <span><?php the_sub_field('heading');?></span>
                                    <?php the_sub_field('content');?>
                                </p>
                            </div>
                            <?php endwhile; endif; ?>  
                        </li> 
                        <li>
                            <div class="bath">
                                <p>
                                    <span><?php the_sub_field('bathroom_heading');?></span>
                                    <?php foreach ( $baths as $bath ){
                                        echo $bath->name;
                                    }?>
                                </p>
                            </div> 
                        </li>                                   
                    </ul>
                    <div class="call-button">
                        <a class="btn-h" href="tel:<?php the_field('phone_no', 'options');?>">
                            <?php the_field('single_property_top_button', 'options');?>
                        </a>
                    </div> 
                </div>
            </div>
            <div class="col-md-12">
                <div class="description-content">
                    <h2><?php the_sub_field('description_heading');?></h2>
                    <?php the_sub_field('description_content');?>
                </div>
            </div>
            <div class="col-md-12">
                <div class="detail-content">
                    <h2><?php the_sub_field('detail_heading');?></h2>
                    <div class="row px-0">
                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <ul>
                                <li>
                                    <?php the_sub_field('bedroom_heading');?> 
                                    <span>
                                        <?php foreach ( $beds as $bed ){
                                            echo $bed->name;
                                        }?>
                                    </span>
                                </li>
                                <li>
                                    <?php the_sub_field('bathroom_heading');?>
                                    <span>
										<?php foreach ( $baths as $bath ){
                                        echo $bath->name;
                                    	}?>
									</span>
								</li>
                                <?php if( have_rows('garrage') ): ?>
                                <?php while( have_rows('garrage') ): the_row(); ?>
                                <li>
                                    <?php the_sub_field('heading');?>
                                    <span><?php the_sub_field('content');?></span>
                                </li>
                                <?php endwhile; endif; ?>

                                <?php if( have_rows('property_size') ): ?>
                                <?php while( have_rows('property_size') ): the_row(); ?>
                                <li>
                                    <?php the_sub_field('heading');?>
                                    <span><?php the_sub_field('content');?></span>
                                </li>
                                <?php endwhile; endif; ?>

                                <?php if( have_rows('parking') ): ?>
                                <?php while( have_rows('parking') ): the_row(); ?>
                                <li>
                                    <?php the_sub_field('heading');?> 
                                    <span><?php the_sub_field('content');?></span>
                                </li>
                                <?php endwhile; endif; ?>
                            </ul>
                        </div>
                        <div class="col-lg-8 col-md-6 col-sm-12 pl-0">
                            <ul>
                                <?php if( have_rows('address') ): ?>
                                <?php while( have_rows('address') ): the_row(); ?>
                                <li>
                                    <?php the_sub_field('heading');?> 
                                    <span><?php the_sub_field('content');?></span>
                                </li>
                                <?php endwhile; endif; ?>

                                <?php if( have_rows('listing_id') ): ?>
                                <?php while( have_rows('listing_id') ): the_row(); ?>
                                <li>
                                    <?php the_sub_field('heading');?>
                                    <span><?php the_sub_field('content');?></span>
                                </li>
                                <?php endwhile; endif; ?>
                            </ul>
                        </div>    
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="feature-content">
                    <h2><?php the_sub_field('feature_heading');?></h2>
                    <ul>
                        <?php if( have_rows('feature_content') ): ?>
                        <?php while( have_rows('feature_content') ): the_row(); ?>
                            <li>
                                <?php the_sub_field('item');?> 
                            </li>
                        <?php endwhile; endif; ?>
                    </ul>
                </div>
            </div>
             <?php } wp_reset_query(); ?>
        </div>
        
    </div>
</section>
<?php endwhile; endif; ?>

<!--CONTACT FORM SECTION-->
<section class="form form-sec">
    <div class="container">
        <div class="row">
            <div class="col-md-7">
                <div class="form-info">
                    <h2><?php the_field('heading', 'options');?></h2>
                    <?php the_field('content', 'options');?>
                    <div class="form-submission">
                        <?php echo do_shortcode('[caldera_form id="CF623be8b73a368"]'); ?>  
                    </div>
                </div>
            </div>
            <div class="col-md-5">
                <div class="drop-img">
                    <img src="<?php the_field('contact_image','options');?>">
                </div>
            </div>
        </div>
    </div>
</section>

<!--PROPERTY SECTION-->
<?php get_template_part('template-parts/feature','properties');?>


<?php get_footer(); ?>


<script>
    lightbox.option({
      'resizeDuration': 200,
      'wrapAround': true
    })
</script>

