<?php  
/**
 * The template for displaying all single posts and attachments
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 * 
 * Template Name: Testimonial Post
 */
get_header();
?>

<!--INNER BANNER SECTION-->
<?php if( have_rows('inner_banner', 'option') ): ?>
        <?php while( have_rows('inner_banner', 'option') ): the_row(); ?>
<section class="inner-banner" style="background-image: url('<?php the_sub_field('background_image', 'option');?>');">
    <div class="container">
        <div class="row">
            <div class= "col-md-12">
                <div class="banner-content">
                    <h1>Testimonial</h1>
                    <strong><?php the_sub_field('subheading', 'option');?></strong>
                </div>            
            </div>
        </div>
    </div>
</section>
<?php endwhile; endif; ?>

<section class="testimonial-single">
    <div class="container">
        <div class="row">     
                <div class="col-lg-5 col-md-6 pr-0">
                    <div class="client-test-img">
                        <img src="<?php the_field('client_image');?>">
                    </div>
                </div>     
                <div class="col-lg-7 col-md-6 pl-0">
                    <div class="testimonial-box">
                        <h3><?php the_title();?></h3>
                        <h3><?php the_field('occupation');?></h3>
                        <img src="<?php the_field('rating_image');?>">
                        <?php the_content();?>                   
                    </div>
                </div>
        </div>
    </div>
</section>

<!--PROPERTY SECTION-->
<section class="property pro-section">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
               <h2>Feature Properties</h2>
            </div>
            <?php
                    $args = array(
                    'post_type' => 'properties',
                        'order' => 'ASC',
                     'posts_per_page' => 3,
                    );
                $query = new WP_Query($args);
                while($query->have_posts()){
                    $query->the_post();
                    $featured_img = get_the_post_thumbnail_url(get_the_ID(), 'full');
                ?> 
            <div class="col-md-4">
                <div class="property-card">
                 <img src="<?php echo $featured_img;?>">
                    <div class="property-inner">
                        <div class="property-intro">
                            <ul>
                                <li><?php the_title();?></li>
                                <li><?php the_field('price');?></li>    
                            </ul>
                        </div>
                        <div class="property-content">
                            <?php the_content();?>
                        </div>
                        <!-- <?php the_excerpt();?> -->
                        <a href="<?php the_permalink();?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18.676" height="10.272" viewBox="0 0 18.676 10.272">
  <path id="arrow_7_" data-name="arrow (7)" d="M289.342,6519.27a.994.994,0,0,1,1.367,0l8,7.718a1.82,1.82,0,0,1,0,2.639l-8.054,7.775a1,1,0,0,1-1.358.008.91.91,0,0,1-.01-1.33l7.371-7.112a.911.911,0,0,0,0-1.321l-7.312-7.057a.91.91,0,0,1,0-1.32" transform="translate(6537.673 -289) rotate(90)" fill="#fff" fill-rule="evenodd"/>
</svg>
                        </a>
                    </div>
                </div>
            </div>
            <?php } ?> 
        </div>
    </div>
</section>


<?php get_footer(); ?>