<?php  
/*
* Template Name: Blog Post
*/
get_header();
global $post;
$author_id=$post->post_author;
$not_id=get_the_ID();
?>

<!--INNER BANNER SECTION-->
<?php if( have_rows('inner_banner', 'option') ): ?>
        <?php while( have_rows('inner_banner', 'option') ): the_row(); ?>
<section class="inner-banner" style="background-image: url('<?php the_sub_field('background_image', 'option');?>');">
    <div class="container">
        <div class="row">
            <div class= "col-md-12">
                <div class="banner-content">
                    <h1>Blog</h1>
                    <strong><?php the_sub_field('subheading', 'option');?></strong>
                </div>            
            </div>
        </div>
    </div>
</section>
<?php endwhile; endif; ?>

<!--SINGLE BLOG PAGE SECTION-->
<section class="blog-single-post">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
            	<div class= "post-upper">
            		<img src="<?php the_field('top_content_image');?>">
            		<p>By <?php echo the_author_meta( 'display_name' , $author_id ); ?>:</p>
            	</div>
				<div class= "post-inner">
					<h5><?php the_title();?></h5>
					<?php the_content();?>
					<div class="post-mid-content">
						<?php the_field('post_mid_content');?>
					</div>
					<?php the_field('post_end_content');?>
				</div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
        	   <h2>Recommended Blogs</h2>
            </div>
            <?php
		
		
                    $args = array(
                    'post_type' => 'post',
                        'order' => 'DESC',
                     'posts_per_page' => -1,
					'post__not_in' => array($not_id),
                    
                    );
                $query = new WP_Query($args);
			?>
			<div class="pro-slider">
				<?php
                while($query->have_posts()){
                    $query->the_post();
                    $featured_img = get_the_post_thumbnail_url(get_the_ID(), 'full');
                ?>

       
                <div class="blog-card">
                 <img src="<?php echo $featured_img;?>">  
                    <div class="blog-card-inner">
                        <div class="blog-intro">
                            <ul>
                                <li>By <?php echo get_the_author(); ?>:</li>
                                <li><?php echo get_the_date();?></li>    
                            </ul>
                        </div>
                        <h5><?php the_title();?></h5>
                        <div class="blog-content">
                            <?php the_content();?>
                        </div>
                        <!-- <?php the_excerpt();?> -->
                        <a href="<?php the_permalink();?>">Read More</a>
                    </div>
                </div>
          
            <?php } ?>
				
						            </div>	
				<?php wp_reset_query();?> 
        </div>
    </div>
</section>

<?php get_footer(); ?>