
<div id="demos" class="wpz-onboard_content-main-tab wpz-onboard_content-main-theme-child demos wpz-onboard_content-side">
    <div class="wpz-onboard_content-side-section block-premium">
        <div class="section-content">
            <div class="header-row">
                <h3 class="wpz-onboard_content-main-title">
                    <?php esc_html_e( 'Premium Starter Sites', 'inspiro' ); ?>
                </h3>
            </div>
            <p class="wpz-onboard_content-main-intro">
                <?php esc_html_e( 'Explore the available demos in the Inspiro Premium theme below. Unlock access to all demos by upgrading to the premium version.', 'inspiro' ); ?>
            </p>
            <p class="section_footer">
                <a href="<?php echo esc_url( __( 'https://www.wpzoom.com/themes/inspiro/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium', 'inspiro' ) ); ?>"
                    target="_blank" class="button button-primary">
                        <?php esc_html_e( 'Discover Inspiro Premium &#8599;', 'inspiro' ); ?>
                </a>
                <a href="<?php echo esc_url( __( 'https://www.wpzoom.com/themes/inspiro/starter-sites/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium', 'inspiro' ) ); ?>"
                    target="_blank" class="button button-primary">
                        <?php esc_html_e( 'Premium Starter Sites &#8599;', 'inspiro' ); ?>
                </a>
            </p>
        </div>
    </div>

    <div class="theme-info-wrap">
        <h3 class="wpz-onboard_content-main-title">
            <?php esc_html_e( 'Inspiro Premium • 36 Starter Sites', 'inspiro' ); ?>
        </h3>
        <div class="theme-buttons filters">
            <a class="button button-common active" data-filter="*">
                <?php esc_html_e( 'All', 'inspiro' ); ?>
            </a>
            <a class="button button-common" data-filter="elementor">
                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M0 8.99998C0 13.9703 4.0297 18 8.99997 18C13.9703 18 18 13.9703 18 8.99998C18 4.0297 13.9703 0 8.99997 0C4.0297 0 0 4.0297 0 8.99998ZM6.74964 5.2499H5.24987V12.7501H6.74964V5.2499ZM8.24943 5.2499H12.7488V6.74967H8.24943V5.2499ZM12.7488 8.24944H8.24943V9.74922H12.7488V8.24944ZM8.24943 11.2503H12.7488V12.7501H8.24943V11.2503Z" fill="#92123A"/>
                </svg>
                <?php esc_html_e( 'Elementor', 'inspiro' ); ?>
            </a>
            <a class="button button-common" data-filter="gutenberg">
                <svg width="18" height="18" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" clip-rule="evenodd" d="M14 28C21.732 28 28 21.732 28 14C28 6.26801 21.732 0 14 0C6.26801 0 0 6.26801 0 14C0 21.732 6.26801 28 14 28ZM20.7598 11.7135C20.5168 11.5354 20.1841 11.6073 20.0192 11.873C19.053 13.4452 17.0019 13.5296 16.8948 13.5296H16.8456C14.3172 13.5296 13.351 15.8614 13.3134 15.9551C13.1977 16.2489 13.322 16.5865 13.5853 16.7147C13.6547 16.7459 13.7328 16.7678 13.7994 16.7678C14.0048 16.7678 14.1986 16.6428 14.2883 16.4209C14.297 16.399 14.9623 14.7955 16.6692 14.6923V17.6774C16.5997 18.3213 16.3191 18.8276 15.8187 19.2058C15.3008 19.5966 14.6094 19.7966 13.7589 19.7966C12.7435 19.7966 11.9132 19.4184 11.2999 18.6682C10.675 17.9181 10.3626 16.8553 10.3626 15.4831L10.3713 12.1918C10.4204 10.979 10.7213 10.0194 11.2999 9.3349C11.9248 8.58473 12.7435 8.20652 13.7589 8.20652C14.6094 8.20652 15.3008 8.40656 15.8187 8.79728C16.3365 9.18799 16.6287 9.72561 16.6779 10.4226V10.4977C16.6779 10.8977 16.9816 11.2259 17.3519 11.2259C17.7222 11.2259 18.026 10.8977 18.026 10.4977V10.4226C17.9276 9.37865 17.4879 8.5566 16.6981 7.93458C15.9083 7.30632 14.9247 7 13.7328 7C12.3182 7 11.1755 7.50636 10.3076 8.50659C9.48891 9.44429 9.05786 10.6789 9.00868 12.198C9.00868 12.2512 9.00651 12.3035 9.00434 12.3559C9.00217 12.4082 9 12.4606 9 12.5137L9.00868 15.4769H9C9 17.1523 9.43973 18.4932 10.3076 19.4934C11.1755 20.4936 12.3182 21 13.7328 21C14.9247 21 15.9083 20.6937 16.701 20.0717C17.4242 19.5028 17.8524 18.7526 17.9999 17.8243L18.0289 14.5142C18.917 14.2829 20.1262 13.7546 20.89 12.5106C21.0809 12.2512 21.0144 11.8917 20.7598 11.7135Z" fill="#242628"/>
				</svg>
                <?php esc_html_e( 'Block Editor', 'inspiro' ); ?>
            </a>
        </div>
     
        <ol class="wpz-onboard_content-main-steps">

            <li id="step-choose-design" class="wpz-onboard_content-main-step step-1 step-choose-design">
                <div class="wpz-onboard_content-main-step-content premium">

                    <form method="post" action="#">

                        <ul id="grid theme-ul">
                            <?php

                                $elementor_svg = '<svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M14 0C6.26727 0 0 6.26723 0 13.9999C0 21.7302 6.26727 28 14 28C21.7327 28 28 21.7326 28 13.9999C27.9976 6.26723 21.7303 0 14 0ZM10.5007 19.8312H8.16859V8.16599H10.5007V19.8312ZM19.8315 19.8312H12.8327V17.4993H19.8315V19.8312ZM19.8315 15.1647H12.8327V12.8327H19.8315V15.1647ZM19.8315 10.4981H12.8327V8.16599H19.8315V10.4981Z" fill="#92123A"/>
                                </svg>';

                                $gutenberg_svg = '<svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M14 28C21.732 28 28 21.732 28 14C28 6.26801 21.732 0 14 0C6.26801 0 0 6.26801 0 14C0 21.732 6.26801 28 14 28ZM20.7598 11.7135C20.5168 11.5354 20.1841 11.6073 20.0192 11.873C19.053 13.4452 17.0019 13.5296 16.8948 13.5296H16.8456C14.3172 13.5296 13.351 15.8614 13.3134 15.9551C13.1977 16.2489 13.322 16.5865 13.5853 16.7147C13.6547 16.7459 13.7328 16.7678 13.7994 16.7678C14.0048 16.7678 14.1986 16.6428 14.2883 16.4209C14.297 16.399 14.9623 14.7955 16.6692 14.6923V17.6774C16.5997 18.3213 16.3191 18.8276 15.8187 19.2058C15.3008 19.5966 14.6094 19.7966 13.7589 19.7966C12.7435 19.7966 11.9132 19.4184 11.2999 18.6682C10.675 17.9181 10.3626 16.8553 10.3626 15.4831L10.3713 12.1918C10.4204 10.979 10.7213 10.0194 11.2999 9.3349C11.9248 8.58473 12.7435 8.20652 13.7589 8.20652C14.6094 8.20652 15.3008 8.40656 15.8187 8.79728C16.3365 9.18799 16.6287 9.72561 16.6779 10.4226V10.4977C16.6779 10.8977 16.9816 11.2259 17.3519 11.2259C17.7222 11.2259 18.026 10.8977 18.026 10.4977V10.4226C17.9276 9.37865 17.4879 8.5566 16.6981 7.93458C15.9083 7.30632 14.9247 7 13.7328 7C12.3182 7 11.1755 7.50636 10.3076 8.50659C9.48891 9.44429 9.05786 10.6789 9.00868 12.198C9.00868 12.2512 9.00651 12.3035 9.00434 12.3559C9.00217 12.4082 9 12.4606 9 12.5137L9.00868 15.4769H9C9 17.1523 9.43973 18.4932 10.3076 19.4934C11.1755 20.4936 12.3182 21 13.7328 21C14.9247 21 15.9083 20.6937 16.701 20.0717C17.4242 19.5028 17.8524 18.7526 17.9999 17.8243L18.0289 14.5142C18.917 14.2829 20.1262 13.7546 20.89 12.5106C21.0809 12.2512 21.0144 11.8917 20.7598 11.7135Z" fill="#242628"/>
                                </svg>';

                                $designs = [
                                    [
                                        'class' => 'design_default-elementor elementor',
                                        'id' => '',
                                        'title' => 'Portfolio (Default)',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro/',
                                        'name' => 'Business / Portfolio',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/business-portfolio/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_default-elementor gutenberg',
                                        'id' => '',
                                        'title' => 'Portfolio (Default)',
                                        'thumbnail_url' => 'https://www.wpzoom.com/wp-content/uploads/2024/12/inspiro-pp-blocks-1.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-premium-blocks/',
                                        'name' => 'Business / Portfolio (Blocks)',
                                        'available_for' => ['Gutenberg'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/gutenberg-block-editor/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_eccentric elementor',
                                        'id' => 'inspiro-eccentric',
                                        'title' => 'Eccentric',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro-pro/flow-1/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-eccentric/',
                                        'name' => 'Eccentric',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/eccentric/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                        'preview_url' => 'https://demo.wpzoom.com/inspiro/',
                                    ],
                                    [
                                        'class' => 'design_default-elementor gutenberg',
                                        'id' => '',
                                        'title' => 'Portfolio (Default)',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-persona/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-persona/',
                                        'name' => 'Persona (Blocks)',
                                        'available_for' => ['Gutenberg'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/persona/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_video elementor',
                                        'id' => 'inspiro-video',
                                        'title' => 'Video Production',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/home-video-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-video/',
                                        'name' => 'Video Production',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/video-portfolio-agency/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_video gutenberg',
                                        'id' => 'inspiro-video-blocks',
                                        'title' => 'Video Production (Blocks)',
                                        'thumbnail_url' => 'https://www.wpzoom.com/wp-content/uploads/2025/02/inspiro-video-blocks.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-video-blocks/',
                                        'name' => 'Video Production (Blocks)',
                                        'available_for' => 'Gutenberg',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/video-portfolio-blocks/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_video2 elementor',
                                        'id' => 'inspiro-video2',
                                        'title' => 'Video Production #2',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/home-video2-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-video2/',
                                        'name' => 'Video Production #2',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/video-portfolio-agency-2/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],

                                    [
                                        'class' => 'design_business elementor',
                                        'id' => 'inspiro-business',
                                        'title' => 'Business',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro-pro/business/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-business/',
                                        'name' => 'Business',
                                        'available_for' => ['Elementor', 'Gutenberg'],
                                        'preview_url' => 'https://demo.wpzoom.com/inspiro-business/',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/business/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',

                                    ],
                                    // [
                                    //     'class' => 'design_offbeat elementor',
                                    //     'id' => 'inspiro-pro-offbeat',
                                    //     'title' => 'Offbeat',
                                    //     'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro-pro/flow-2/home-thumb.png',
                                    //     'demo_url' => 'https://demo.wpzoom.com/inspiro-pro-2/',
                                    //     'name' => 'Offbeat',
                                    //     'available_for' => 'Elementor',
                                    //     'premium_url' => 'https://www.wpzoom.com/themes/inspiro-pro/',
                                    //     'preview_url' => 'https://demo.wpzoom.com/inspiro-pro-2/',
                                    // ],

                                    // [
                                    //     'class' => 'design_shop elementor',
                                    //     'id' => 'inspiro-pro-shop',
                                    //     'title' => 'Shop',
                                    //     'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro-pro/shop/home-thumb.png',
                                    //     'demo_url' => 'https://demo.wpzoom.com/inspiro-pro-shop/',
                                    //     'name' => 'Shop',
                                    //     'available_for' => 'Elementor',
                                    //     'premium_url' => 'https://www.wpzoom.com/themes/inspiro-pro/',
                                    //     'preview_url' => 'https://demo.wpzoom.com/inspiro-pro-shop/',
                                    // ]
                                    // [
                                    //     'class' => 'design_real-estate elementor',
                                    //     'id' => 'inspiro-pro-real-estate',
                                    //     'title' => 'Real Estate / Business',
                                    //     'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro-pro/real-estate/home-thumb.png',
                                    //     'demo_url' => 'https://demo.wpzoom.com/inspiro-pro-real-estate/',
                                    //     'name' => 'Real Estate / Business',
                                    //     'available_for' => 'Elementor',
                                    //     'premium_url' => 'https://www.wpzoom.com/themes/inspiro-pro/',
                                    //     'preview_url' => 'https://demo.wpzoom.com/inspiro-pro-real-estate/',
                                    // ],
                                    // [
                                    //     'class' => 'design_tech elementor',
                                    //     'id' => 'inspiro-tech',
                                    //     'title' => 'Tech',
                                    //     'thumbnail_url' => 'https://demo.wpzoom.com/inspiro-pro-demo/wp-content/themes/inspiro-pro-select/images/site-layout_tech.png',
                                    //     'demo_url' => 'https://demo.wpzoom.com/inspiro-tech/',
                                    //     'name' => 'Tech / Finance',
                                    //     'available_for' => 'Elementor',
                                    //     'premium_url' => 'https://www.wpzoom.com/themes/inspiro-pro/',
                                    //     'preview_url' => 'https://demo.wpzoom.com/inspiro-tech/',
                                    // ],
                                    [
                                        'class' => 'design_agency-elementor elementor',
                                        'id' => 'inspiro-agency',
                                        'title' => 'Agency / Business',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/home-agency-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-agency/',
                                        'name' => 'Agency / Business #2',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/agency/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_video elementor',
                                        'id' => '',
                                        'title' => 'Portfolio (Default)',
                                        'thumbnail_url' => 'https://demo.wpzoom.com/inspiro-pro-demo/wp-content/themes/inspiro-pro-select/images/site-layout_agency-dark.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-agency2/',
                                        'name' => 'Agency / Business',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/agency-business-2/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_kids elementor',
                                        'id' => 'inspiro-kids',
                                        'title' => 'Camp',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-scout/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-kids/',
                                        'name' => 'Kids Summer Camp',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/kids-summer-camp/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_architecture elementor',
                                        'id' => 'inspiro-architecture',
                                        'title' => 'Architecture',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-architecture/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-architecture/',
                                        'name' => 'Architecture',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/architecture/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_photography elementor',
                                        'id' => 'inspiro-wedding-photography',
                                        'title' => 'Photographer',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/wedding/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-wedding-photography/',
                                        'name' => 'Wedding Photographer',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/wedding-photographer/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_photography elementor',
                                        'id' => 'inspiro-photography',
                                        'title' => 'Photography',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/home-photography-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-photography/',
                                        'name' => 'Photography',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/photography-wedding/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_food elementor',
                                        'id' => 'inspiro-food',
                                        'title' => 'Food Blog',
                                        'thumbnail_url' => 'https://www.wpzoom.com/wp-content/uploads/2024/12/inspiro-recipe-1.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-recipe/',
                                        'name' => 'Food Blog',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/food-blog/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_coffee elementor',
                                        'id' => 'inspiro-coffee',
                                        'title' => 'Coffee Shop',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-coffee/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-coffee-shop/',
                                        'name' => 'Coffee Shop',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/coffee-shop/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_hotel elementor',
                                        'id' => 'inspiro-construction',
                                        'title' => 'Construction',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-construction/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-construction/',
                                        'name' => 'Construction',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/construction/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_hotel elementor',
                                        'id' => 'inspiro-education',
                                        'title' => 'Education / University',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-education/thumbs/home.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-school/',
                                        'name' => 'Education / University',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/education/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_hotel elementor',
                                        'id' => 'inspiro-lawyer',
                                        'title' => 'Lawyer / Law Firm',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-lawyer/thumbs/home.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-lawyer/',
                                        'name' => 'Lawyer / Law Firm',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/lawyer/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_hotel elementor',
                                        'id' => 'inspiro-insurance',
                                        'title' => 'Insurance Company',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-insurance/thumbs/home.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-insurance/',
                                        'name' => 'Insurance Company',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/insurance/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_hotel elementor',
                                        'id' => 'inspiro-hotel',
                                        'title' => 'Hotel',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/home-hotel-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-hotel/',
                                        'name' => 'Hotel / Real Estate',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/hotel-real-estate/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_events elementor gutenberg',
                                        'id' => 'inspiro-shop',
                                        'title' => 'Shop / WooCommerce',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/shop-home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-shop/',
                                        'name' => 'Shop / WooCommerce',
                                        'available_for' => ['Elementor', 'Gutenberg'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/gear-shop-woocommerce/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_events elementor gutenberg',
                                        'id' => 'inspiro-jewelry',
                                        'title' => 'Jewelry Shop / WooCommerce',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/shop2/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-jewelry2/',
                                        'name' => 'Jewelry Shop / WooCommerce',
                                        'available_for' => ['Elementor'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/jewelry-shop-woocommerce/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_restaurant elementor',
                                        'id' => 'inspiro-restaurant',
                                        'title' => 'Restaurant',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/home-restaurant-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-restaurant/',
                                        'name' => 'Restaurant',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/restaurant-cafe/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_events elementor',
                                        'id' => 'inspiro-events',
                                        'title' => 'Events / Conference',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/demo-events.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-event/',
                                        'name' => 'Events / Conference',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/events-conference/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_wellness elementor',
                                        'id' => 'inspiro-wellness',
                                        'title' => 'Wellness / Spa',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-wellness/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-wellness/',
                                        'name' => 'Wellness / Spa',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/wellness-spa/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_wellness elementor',
                                        'id' => 'inspiro-fitness',
                                        'title' => 'Gym / Fitness',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro-pro/fitness/fitness-home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-fitness/',
                                        'name' => 'Gym / Fitness',
                                        'available_for' => 'Gutenberg',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/fitness-gym/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_magazine elementor',
                                        'id' => 'inspiro-magazine',
                                        'title' => 'Magazine',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-magazine/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-magazine/',
                                        'name' => 'Magazine',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/magazine/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_magazine elementor',
                                        'id' => 'inspiro-auto',
                                        'title' => 'Car Rental',
                                        'thumbnail_url' => 'https://demo.wpzoom.com/inspiro-demo/wp-content/themes/inspiro-select/images/inspiro-rent.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-auto/',
                                        'name' => 'Car Rental / Dealer',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/car-rental/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_magazine elementor gutenberg',
                                        'id' => 'inspiro-coach',
                                        'title' => 'Author / Coach',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-author/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-author/',
                                        'name' => 'Author / Coach',
                                        'available_for' => ['Elementor', 'Gutenberg'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/author-coach/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_magazine elementor',
                                        'id' => 'inspiro-church',
                                        'title' => 'Church',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-church/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-church/',
                                        'name' => 'Church',
                                        'available_for' => 'Elementor',
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/church/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_medical elementor gutenberg',
                                        'id' => 'inspiro-medical',
                                        'title' => 'Doctor / Medical',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-medical/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-medical/',
                                        'name' => 'Doctor / Medical',
                                        'available_for' => ['Elementor', 'Gutenberg'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/medical-doctor/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_winery gutenberg',
                                        'id' => 'inspiro-pro-winery',
                                        'title' => 'Winery',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro-pro/winery/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-pro-winery/',
                                        'name' => 'Winery',
                                        'available_for' => ['Gutenberg'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/winery/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_charity gutenberg',
                                        'id' => 'inspiro-pro-charity',
                                        'title' => 'Charity / NGO',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro-pro/charity/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-pro-charity/',
                                        'name' => 'Charity / NGO',
                                        'available_for' => ['Gutenberg'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/charity-ngo/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_tech gutenberg',
                                        'id' => 'inspiro-tech',
                                        'title' => 'Tech',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-finance/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-finance/',
                                        'name' => 'Tech / Finance',
                                        'available_for' => ['Gutenberg'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/finance-tech/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                    [
                                        'class' => 'design_tech gutenberg',
                                        'id' => 'inspiro-freelancer',
                                        'title' => 'Freelancer (One-pager)',
                                        'thumbnail_url' => 'https://wpzoom.s3.us-east-1.amazonaws.com/elementor/templates/assets/thumbs/inspiro/inspiro-freelancer/home-thumb.png',
                                        'demo_url' => 'https://demo.wpzoom.com/inspiro-freelancer2/',
                                        'name' => 'Freelancer (One-pager)',
                                        'available_for' => ['Gutenberg'],
                                        'premium_url' => 'https://www.wpzoom.com/themes/inspiro/starter-sites/freelancer-2/?utm_source=wpadmin&utm_medium=demos-inspiro-page&utm_campaign=upgrade-premium',
                                    ],
                                ];

                                foreach ($designs as $design) :
                            ?>
                            <li class="<?php echo esc_attr($design['class']); ?>" data-design-id="<?php echo esc_attr($design['id']); ?>">
                                <figure title="<?php echo esc_attr($design['title']); ?>">
                                    <div class="preview-thumbnail-demo">
                                        <a href="<?php echo esc_url($design['demo_url']); ?>" target="_blank"><img src="<?php echo esc_url($design['thumbnail_url']); ?>" alt="<?php echo esc_attr($design['title']); ?>" /></a>
                                    </div>
                                    <figcaption>
                                        <h5><?php echo esc_html($design['name']); ?></h5>
                                        <p>
                                            <?php esc_html_e('Available for ', 'inspiro'); ?>
                                            <?php 
                                                if (!empty($design['available_for'])) {
                                                    $builders = is_array($design['available_for']) ? $design['available_for'] : [$design['available_for']];
                                                    foreach ($builders as $builder) {
                                                        if ($builder === 'Elementor') {
                                                            echo $elementor_svg;
                                                        } elseif ($builder === 'Gutenberg') {
                                                            echo $gutenberg_svg;
                                                        }
                                                    }
                                                }
                                            ?>
                                        </p>
                                        <a href="<?php echo esc_url($design['premium_url']); ?>" target="_blank" class="button button-primary">
                                            <?php esc_html_e('More Info', 'inspiro'); ?>
                                        </a>
                                        <a href="<?php echo esc_url($design['demo_url']); ?>" target="_blank" class="button button-secondary-gray">
                                            <?php esc_html_e('Preview', 'inspiro'); ?>
                                        </a>
                                    </figcaption>
                                </figure>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </form>
                </div>
            </li>
        </ol>    
    </div>

</div>